// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../../resource.mjs";
export class Entries extends APIResource {
    /**
     * Create IPFS Universal Path Gateway Content List Entry
     */
    create(identifier, params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/web3/hostnames/${identifier}/ipfs_universal_path/content_list/entries`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Edit IPFS Universal Path Gateway Content List Entry
     */
    update(identifier, contentListEntryIdentifier, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/web3/hostnames/${identifier}/ipfs_universal_path/content_list/entries/${contentListEntryIdentifier}`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List IPFS Universal Path Gateway Content List Entries
     */
    list(identifier, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/web3/hostnames/${identifier}/ipfs_universal_path/content_list/entries`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Delete IPFS Universal Path Gateway Content List Entry
     */
    delete(identifier, contentListEntryIdentifier, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/web3/hostnames/${identifier}/ipfs_universal_path/content_list/entries/${contentListEntryIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * IPFS Universal Path Gateway Content List Entry Details
     */
    get(identifier, contentListEntryIdentifier, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/web3/hostnames/${identifier}/ipfs_universal_path/content_list/entries/${contentListEntryIdentifier}`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=entries.mjs.map