// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import * as ScriptsAPI from "./scripts/scripts.mjs";
import { Scripts, } from "./scripts/scripts.mjs";
import { SinglePage } from "../../../../pagination.mjs";
export class Namespaces extends APIResource {
    constructor() {
        super(...arguments);
        this.scripts = new ScriptsAPI.Scripts(this._client);
    }
    /**
     * Create a new Workers for Platforms namespace.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/workers/dispatch/namespaces`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a list of Workers for Platforms namespaces.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/workers/dispatch/namespaces`, NamespaceListResponsesSinglePage, options);
    }
    /**
     * Delete a Workers for Platforms namespace.
     */
    delete(dispatchNamespace, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/workers/dispatch/namespaces/${dispatchNamespace}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a Workers for Platforms namespace.
     */
    get(dispatchNamespace, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/workers/dispatch/namespaces/${dispatchNamespace}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class NamespaceListResponsesSinglePage extends SinglePage {
}
Namespaces.NamespaceListResponsesSinglePage = NamespaceListResponsesSinglePage;
Namespaces.Scripts = Scripts;
//# sourceMappingURL=namespaces.mjs.map