import { APIResource } from "../../../../../resource.js";
import * as Core from "../../../../../core.js";
import { SinglePage } from "../../../../../pagination.js";
export declare class Tags extends APIResource {
    /**
     * Put script tags for a script uploaded to a Workers for Platforms namespace.
     */
    update(dispatchNamespace: string, scriptName: string, params: TagUpdateParams, options?: Core.RequestOptions): Core.PagePromise<TagUpdateResponsesSinglePage, TagUpdateResponse>;
    /**
     * Fetch tags from a script uploaded to a Workers for Platforms namespace.
     */
    list(dispatchNamespace: string, scriptName: string, params: TagListParams, options?: Core.RequestOptions): Core.PagePromise<TagListResponsesSinglePage, TagListResponse>;
    /**
     * Delete script tag for a script uploaded to a Workers for Platforms namespace.
     */
    delete(dispatchNamespace: string, scriptName: string, tag: string, params: TagDeleteParams, options?: Core.RequestOptions): Core.APIPromise<TagDeleteResponse | null>;
}
export declare class TagUpdateResponsesSinglePage extends SinglePage<TagUpdateResponse> {
}
export declare class TagListResponsesSinglePage extends SinglePage<TagListResponse> {
}
/**
 * Tag to help you manage your Worker
 */
export type TagUpdateResponse = string;
/**
 * Tag to help you manage your Worker
 */
export type TagListResponse = string;
export type TagDeleteResponse = unknown;
export interface TagUpdateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: Tags to help you manage your Workers
     */
    body: Array<string>;
}
export interface TagListParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface TagDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Tags {
    export { type TagUpdateResponse as TagUpdateResponse, type TagListResponse as TagListResponse, type TagDeleteResponse as TagDeleteResponse, TagUpdateResponsesSinglePage as TagUpdateResponsesSinglePage, TagListResponsesSinglePage as TagListResponsesSinglePage, type TagUpdateParams as TagUpdateParams, type TagListParams as TagListParams, type TagDeleteParams as TagDeleteParams, };
}
//# sourceMappingURL=tags.d.ts.map