// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../../resource.mjs";
import { SinglePage } from "../../../../../pagination.mjs";
export class Tags extends APIResource {
    /**
     * Put script tags for a script uploaded to a Workers for Platforms namespace.
     */
    update(dispatchNamespace, scriptName, params, options) {
        const { account_id, body } = params;
        return this._client.getAPIList(`/accounts/${account_id}/workers/dispatch/namespaces/${dispatchNamespace}/scripts/${scriptName}/tags`, TagUpdateResponsesSinglePage, { body: body, method: 'put', ...options });
    }
    /**
     * Fetch tags from a script uploaded to a Workers for Platforms namespace.
     */
    list(dispatchNamespace, scriptName, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/workers/dispatch/namespaces/${dispatchNamespace}/scripts/${scriptName}/tags`, TagListResponsesSinglePage, options);
    }
    /**
     * Delete script tag for a script uploaded to a Workers for Platforms namespace.
     */
    delete(dispatchNamespace, scriptName, tag, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/workers/dispatch/namespaces/${dispatchNamespace}/scripts/${scriptName}/tags/${tag}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class TagUpdateResponsesSinglePage extends SinglePage {
}
export class TagListResponsesSinglePage extends SinglePage {
}
Tags.TagUpdateResponsesSinglePage = TagUpdateResponsesSinglePage;
Tags.TagListResponsesSinglePage = TagListResponsesSinglePage;
//# sourceMappingURL=tags.mjs.map