// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class AccountSettings extends APIResource {
    /**
     * Creates Worker account settings for an account.
     */
    update(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/workers/account-settings`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches Worker account settings for an account.
     */
    get(params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/workers/account-settings`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=account-settings.mjs.map