"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DomainsSinglePage = exports.Domains = void 0;
const resource_1 = require("../../resource.js");
const pagination_1 = require("../../pagination.js");
class Domains extends resource_1.APIResource {
    /**
     * Attaches a Worker to a zone and hostname.
     */
    update(params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/workers/domains`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists all Worker Domains for an account.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/workers/domains`, DomainsSinglePage, {
            query,
            ...options,
        });
    }
    /**
     * Detaches a Worker from a zone and hostname.
     */
    delete(domainId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/workers/domains/${domainId}`, {
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
    /**
     * Gets a Worker domain.
     */
    get(domainId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/workers/domains/${domainId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Domains = Domains;
class DomainsSinglePage extends pagination_1.SinglePage {
}
exports.DomainsSinglePage = DomainsSinglePage;
Domains.DomainsSinglePage = DomainsSinglePage;
//# sourceMappingURL=domains.js.map