import { APIResource } from "../../resource.js";
import * as Core from "../../core.js";
import * as Shared from "../shared.js";
import { SinglePage } from "../../pagination.js";
export declare class Routes extends APIResource {
    /**
     * Creates a route that maps a URL pattern to a Worker.
     */
    create(params: RouteCreateParams, options?: Core.RequestOptions): Core.APIPromise<RouteCreateResponse>;
    /**
     * Updates the URL pattern or Worker associated with a route.
     */
    update(routeId: string, params: RouteUpdateParams, options?: Core.RequestOptions): Core.APIPromise<RouteUpdateResponse>;
    /**
     * Returns routes for a zone.
     */
    list(params: RouteListParams, options?: Core.RequestOptions): Core.PagePromise<RouteListResponsesSinglePage, RouteListResponse>;
    /**
     * Deletes a route.
     */
    delete(routeId: string, params: RouteDeleteParams, options?: Core.RequestOptions): Core.APIPromise<RouteDeleteResponse>;
    /**
     * Returns information about a route, including URL pattern and Worker.
     */
    get(routeId: string, params: RouteGetParams, options?: Core.RequestOptions): Core.APIPromise<RouteGetResponse>;
}
export declare class RouteListResponsesSinglePage extends SinglePage<RouteListResponse> {
}
export interface RouteCreateResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
}
export interface RouteUpdateResponse {
    /**
     * Identifier
     */
    id: string;
    pattern: string;
    /**
     * Name of the script, used in URLs and route configuration.
     */
    script: string;
}
export interface RouteListResponse {
    /**
     * Identifier
     */
    id: string;
    pattern: string;
    /**
     * Name of the script, used in URLs and route configuration.
     */
    script: string;
}
export interface RouteDeleteResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
}
export interface RouteGetResponse {
    /**
     * Identifier
     */
    id: string;
    pattern: string;
    /**
     * Name of the script, used in URLs and route configuration.
     */
    script: string;
}
export interface RouteCreateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param:
     */
    pattern: string;
    /**
     * Body param: Name of the script, used in URLs and route configuration.
     */
    script?: string;
}
export interface RouteUpdateParams {
    /**
     * Path param: Identifier
     */
    zone_id: string;
    /**
     * Body param:
     */
    pattern: string;
    /**
     * Body param: Name of the script, used in URLs and route configuration.
     */
    script?: string;
}
export interface RouteListParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface RouteDeleteParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export interface RouteGetParams {
    /**
     * Identifier
     */
    zone_id: string;
}
export declare namespace Routes {
    export { type RouteCreateResponse as RouteCreateResponse, type RouteUpdateResponse as RouteUpdateResponse, type RouteListResponse as RouteListResponse, type RouteDeleteResponse as RouteDeleteResponse, type RouteGetResponse as RouteGetResponse, RouteListResponsesSinglePage as RouteListResponsesSinglePage, type RouteCreateParams as RouteCreateParams, type RouteUpdateParams as RouteUpdateParams, type RouteListParams as RouteListParams, type RouteDeleteParams as RouteDeleteParams, type RouteGetParams as RouteGetParams, };
}
//# sourceMappingURL=routes.d.ts.map