// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
import { SinglePage } from "../../pagination.mjs";
export class Routes extends APIResource {
    /**
     * Creates a route that maps a URL pattern to a Worker.
     */
    create(params, options) {
        const { zone_id, ...body } = params;
        return this._client.post(`/zones/${zone_id}/workers/routes`, { body, ...options });
    }
    /**
     * Updates the URL pattern or Worker associated with a route.
     */
    update(routeId, params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/workers/routes/${routeId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Returns routes for a zone.
     */
    list(params, options) {
        const { zone_id } = params;
        return this._client.getAPIList(`/zones/${zone_id}/workers/routes`, RouteListResponsesSinglePage, options);
    }
    /**
     * Deletes a route.
     */
    delete(routeId, params, options) {
        const { zone_id } = params;
        return this._client.delete(`/zones/${zone_id}/workers/routes/${routeId}`, options);
    }
    /**
     * Returns information about a route, including URL pattern and Worker.
     */
    get(routeId, params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/workers/routes/${routeId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class RouteListResponsesSinglePage extends SinglePage {
}
Routes.RouteListResponsesSinglePage = RouteListResponsesSinglePage;
//# sourceMappingURL=routes.mjs.map