"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Upload = void 0;
const resource_1 = require("../../../../resource.js");
class Upload extends resource_1.APIResource {
    /**
     * Start uploading a collection of assets for use in a Worker version. To learn
     * more about the direct uploads of assets, see
     * https://developers.cloudflare.com/workers/static-assets/direct-upload/
     */
    create(scriptName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/workers/scripts/${scriptName}/assets-upload-session`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
exports.Upload = Upload;
//# sourceMappingURL=upload.js.map