// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Deployments extends APIResource {
    /**
     * Deployments configure how
     * [Worker Versions](https://developers.cloudflare.com/api/operations/worker-versions-list-versions)
     * are deployed to traffic. A deployment can consist of one or two versions of a
     * Worker.
     */
    create(scriptName, params, options) {
        const { account_id, force, ...body } = params;
        return this._client.post(`/accounts/${account_id}/workers/scripts/${scriptName}/deployments`, {
            query: { force },
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List of Worker Deployments. The first deployment in the list is the latest
     * deployment actively serving traffic.
     */
    get(scriptName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/workers/scripts/${scriptName}/deployments`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=deployments.mjs.map