import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class Schedules extends APIResource {
    /**
     * Updates Cron Triggers for a Worker.
     */
    update(scriptName: string, params: ScheduleUpdateParams, options?: Core.RequestOptions): Core.APIPromise<ScheduleUpdateResponse>;
    /**
     * Fetches Cron Triggers for a Worker.
     */
    get(scriptName: string, params: ScheduleGetParams, options?: Core.RequestOptions): Core.APIPromise<ScheduleGetResponse>;
}
export interface Schedule {
    created_on?: string;
    cron?: string;
    modified_on?: string;
}
export interface ScheduleParam {
    cron?: string;
}
export interface ScheduleUpdateResponse {
    schedules?: Array<Schedule>;
}
export interface ScheduleGetResponse {
    schedules?: Array<Schedule>;
}
export interface ScheduleUpdateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    body: Array<ScheduleParam>;
}
export interface ScheduleGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Schedules {
    export { type Schedule as Schedule, type ScheduleUpdateResponse as ScheduleUpdateResponse, type ScheduleGetResponse as ScheduleGetResponse, type ScheduleUpdateParams as ScheduleUpdateParams, type ScheduleGetParams as ScheduleGetParams, };
}
//# sourceMappingURL=schedules.d.ts.map