// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Schedules extends APIResource {
    /**
     * Updates Cron Triggers for a Worker.
     */
    update(scriptName, params, options) {
        const { account_id, body } = params;
        return this._client.put(`/accounts/${account_id}/workers/scripts/${scriptName}/schedules`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches Cron Triggers for a Worker.
     */
    get(scriptName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/workers/scripts/${scriptName}/schedules`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=schedules.mjs.map