// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Secrets extends APIResource {
    /**
     * Add a secret to a script.
     */
    update(scriptName, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/workers/scripts/${scriptName}/secrets`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List secrets bound to a script.
     */
    list(scriptName, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/workers/scripts/${scriptName}/secrets`, SecretListResponsesSinglePage, options);
    }
    /**
     * Remove a secret from a script.
     */
    delete(scriptName, secretName, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/workers/scripts/${scriptName}/secrets/${secretName}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a given secret binding (value omitted) on a script.
     */
    get(scriptName, secretName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/workers/scripts/${scriptName}/secrets/${secretName}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class SecretListResponsesSinglePage extends SinglePage {
}
Secrets.SecretListResponsesSinglePage = SecretListResponsesSinglePage;
//# sourceMappingURL=secrets.mjs.map