import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as ScriptsAPI from "./scripts.js";
import * as TailAPI from "./tail.js";
export declare class Settings extends APIResource {
    /**
     * Patch script-level settings when using
     * [Worker Versions](https://developers.cloudflare.com/api/operations/worker-versions-list-versions).
     * Including but not limited to Logpush and Tail Consumers.
     */
    edit(scriptName: string, params: SettingEditParams, options?: Core.RequestOptions): Core.APIPromise<ScriptsAPI.ScriptSetting>;
    /**
     * Get script-level settings when using
     * [Worker Versions](https://developers.cloudflare.com/api/operations/worker-versions-list-versions).
     * Includes Logpush and Tail Consumers.
     */
    get(scriptName: string, params: SettingGetParams, options?: Core.RequestOptions): Core.APIPromise<ScriptsAPI.ScriptSetting>;
}
export interface SettingEditParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: Whether Logpush is turned on for the Worker.
     */
    logpush?: boolean;
    /**
     * Body param: Observability settings for the Worker.
     */
    observability?: SettingEditParams.Observability;
    /**
     * Body param: List of Workers that will consume logs from the attached Worker.
     */
    tail_consumers?: Array<TailAPI.ConsumerScriptParam>;
}
export declare namespace SettingEditParams {
    /**
     * Observability settings for the Worker.
     */
    interface Observability {
        /**
         * Whether observability is enabled for the Worker.
         */
        enabled: boolean;
        /**
         * The sampling rate for incoming requests. From 0 to 1 (1 = 100%, 0.1 = 10%).
         * Default is 1.
         */
        head_sampling_rate?: number | null;
    }
}
export interface SettingGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Settings {
    export { type SettingEditParams as SettingEditParams, type SettingGetParams as SettingGetParams };
}
//# sourceMappingURL=settings.d.ts.map