"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Settings = void 0;
const resource_1 = require("../../../resource.js");
class Settings extends resource_1.APIResource {
    /**
     * Patch script-level settings when using
     * [Worker Versions](https://developers.cloudflare.com/api/operations/worker-versions-list-versions).
     * Including but not limited to Logpush and Tail Consumers.
     */
    edit(scriptName, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/workers/scripts/${scriptName}/script-settings`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get script-level settings when using
     * [Worker Versions](https://developers.cloudflare.com/api/operations/worker-versions-list-versions).
     * Includes Logpush and Tail Consumers.
     */
    get(scriptName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/workers/scripts/${scriptName}/script-settings`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Settings = Settings;
//# sourceMappingURL=settings.js.map