"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.Subdomain = void 0;
const resource_1 = require("../../../resource.js");
class Subdomain extends resource_1.APIResource {
    /**
     * Enable or disable the Worker on the workers.dev subdomain.
     */
    create(scriptName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/workers/scripts/${scriptName}/subdomain`, {
            body,
            ...options,
        });
    }
    /**
     * Get if the Worker is available on the workers.dev subdomain.
     */
    get(scriptName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/workers/scripts/${scriptName}/subdomain`, options);
    }
}
exports.Subdomain = Subdomain;
//# sourceMappingURL=subdomain.js.map