// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Subdomain extends APIResource {
    /**
     * Enable or disable the Worker on the workers.dev subdomain.
     */
    create(scriptName, params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/workers/scripts/${scriptName}/subdomain`, {
            body,
            ...options,
        });
    }
    /**
     * Get if the Worker is available on the workers.dev subdomain.
     */
    get(scriptName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/workers/scripts/${scriptName}/subdomain`, options);
    }
}
//# sourceMappingURL=subdomain.mjs.map