import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import * as Shared from "../../shared.js";
export declare class Tail extends APIResource {
    /**
     * Starts a tail that receives logs and exception from a Worker.
     */
    create(scriptName: string, params: TailCreateParams, options?: Core.RequestOptions): Core.APIPromise<TailCreateResponse>;
    /**
     * Deletes a tail from a Worker.
     */
    delete(scriptName: string, id: string, params: TailDeleteParams, options?: Core.RequestOptions): Core.APIPromise<TailDeleteResponse>;
    /**
     * Get list of tails currently deployed on a Worker.
     */
    get(scriptName: string, params: TailGetParams, options?: Core.RequestOptions): Core.APIPromise<TailGetResponse>;
}
/**
 * A reference to a script that will consume logs from the attached Worker.
 */
export interface ConsumerScript {
    /**
     * Name of Worker that is to be the consumer.
     */
    service: string;
    /**
     * Optional environment if the Worker utilizes one.
     */
    environment?: string;
    /**
     * Optional dispatch namespace the script belongs to.
     */
    namespace?: string;
}
/**
 * A reference to a script that will consume logs from the attached Worker.
 */
export interface ConsumerScriptParam {
    /**
     * Name of Worker that is to be the consumer.
     */
    service: string;
    /**
     * Optional environment if the Worker utilizes one.
     */
    environment?: string;
    /**
     * Optional dispatch namespace the script belongs to.
     */
    namespace?: string;
}
export interface TailCreateResponse {
    id?: string;
    expires_at?: string;
    url?: string;
}
export interface TailDeleteResponse {
    errors: Array<Shared.ResponseInfo>;
    messages: Array<Shared.ResponseInfo>;
    /**
     * Whether the API call was successful
     */
    success: true;
}
export interface TailGetResponse {
    id?: string;
    expires_at?: string;
    url?: string;
}
export interface TailCreateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param:
     */
    body: unknown;
}
export interface TailDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface TailGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Tail {
    export { type ConsumerScript as ConsumerScript, type TailCreateResponse as TailCreateResponse, type TailDeleteResponse as TailDeleteResponse, type TailGetResponse as TailGetResponse, type TailCreateParams as TailCreateParams, type TailDeleteParams as TailDeleteParams, type TailGetParams as TailGetParams, };
}
//# sourceMappingURL=tail.d.ts.map