// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
export class Tail extends APIResource {
    /**
     * Starts a tail that receives logs and exception from a Worker.
     */
    create(scriptName, params, options) {
        const { account_id, body } = params;
        return this._client.post(`/accounts/${account_id}/workers/scripts/${scriptName}/tails`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Deletes a tail from a Worker.
     */
    delete(scriptName, id, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/workers/scripts/${scriptName}/tails/${id}`, options);
    }
    /**
     * Get list of tails currently deployed on a Worker.
     */
    get(scriptName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/workers/scripts/${scriptName}/tails`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=tail.mjs.map