// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../resource.mjs";
export class Config extends APIResource {
    /**
     * Updates Zaraz configuration for a zone.
     */
    update(params, options) {
        const { zone_id, ...body } = params;
        return this._client.put(`/zones/${zone_id}/settings/zaraz/config`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Gets latest Zaraz configuration for a zone. It can be preview or published
     * configuration, whichever was the last updated. Secret variables values will not
     * be included.
     */
    get(params, options) {
        const { zone_id } = params;
        return this._client.get(`/zones/${zone_id}/settings/zaraz/config`, options)._thenUnwrap((obj) => obj.result);
    }
}
//# sourceMappingURL=config.mjs.map