"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.HistoryListResponsesSinglePage = exports.History = void 0;
const resource_1 = require("../../../resource.js");
const ConfigsAPI = __importStar(require("./configs.js"));
const configs_1 = require("./configs.js");
const pagination_1 = require("../../../pagination.js");
class History extends resource_1.APIResource {
    constructor() {
        super(...arguments);
        this.configs = new ConfigsAPI.Configs(this._client);
    }
    /**
     * Restores a historical published Zaraz configuration by ID for a zone.
     */
    update(params, options) {
        const { zone_id, body } = params;
        return this._client.put(`/zones/${zone_id}/settings/zaraz/history`, {
            body: body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists a history of published Zaraz configuration records for a zone.
     */
    list(params, options) {
        const { zone_id, ...query } = params;
        return this._client.getAPIList(`/zones/${zone_id}/settings/zaraz/history`, HistoryListResponsesSinglePage, { query, ...options });
    }
}
exports.History = History;
class HistoryListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.HistoryListResponsesSinglePage = HistoryListResponsesSinglePage;
History.HistoryListResponsesSinglePage = HistoryListResponsesSinglePage;
History.Configs = configs_1.Configs;
//# sourceMappingURL=history.js.map