// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../../resource.mjs";
import * as UsersAPI from "./users.mjs";
import { UserListResponsesSinglePage, Users } from "./users.mjs";
export class PolicyTests extends APIResource {
    constructor() {
        super(...arguments);
        this.users = new UsersAPI.Users(this._client);
    }
    /**
     * Starts an Access policy test.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/access/policy-tests`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches the current status of a given Access policy test.
     */
    get(policyTestId, params, options) {
        const { account_id, ...query } = params;
        return this._client.get(`/accounts/${account_id}/access/policy-tests/${policyTestId}`, {
            query,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
}
PolicyTests.Users = Users;
PolicyTests.UserListResponsesSinglePage = UserListResponsesSinglePage;
//# sourceMappingURL=policy-tests.mjs.map