import { APIResource } from "../../../../../resource.js";
import * as Core from "../../../../../core.js";
import { SinglePage } from "../../../../../pagination.js";
export declare class Users extends APIResource {
    /**
     * Fetches a single page of user results from an Access policy test.
     */
    list(policyTestId: string, params: UserListParams, options?: Core.RequestOptions): Core.PagePromise<UserListResponsesSinglePage, UserListResponse>;
}
export declare class UserListResponsesSinglePage extends SinglePage<UserListResponse> {
}
export interface UserListResponse {
    /**
     * UUID
     */
    id?: string;
    /**
     * The email of the user.
     */
    email?: string;
    /**
     * The name of the user.
     */
    name?: string;
    /**
     * Policy evaluation result for an individual user.
     */
    status?: 'approved' | 'blocked';
}
export interface UserListParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Query param: Filter users by their policy evaluation status.
     */
    status?: 'success' | 'fail';
}
export declare namespace Users {
    export { type UserListResponse as UserListResponse, UserListResponsesSinglePage as UserListResponsesSinglePage, type UserListParams as UserListParams, };
}
//# sourceMappingURL=users.d.ts.map