"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserListResponsesSinglePage = exports.Users = void 0;
const resource_1 = require("../../../../../resource.js");
const pagination_1 = require("../../../../../pagination.js");
class Users extends resource_1.APIResource {
    /**
     * Fetches a single page of user results from an Access policy test.
     */
    list(policyTestId, params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/policy-tests/${policyTestId}/users`, UserListResponsesSinglePage, { query, ...options });
    }
}
exports.Users = Users;
class UserListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.UserListResponsesSinglePage = UserListResponsesSinglePage;
Users.UserListResponsesSinglePage = UserListResponsesSinglePage;
//# sourceMappingURL=users.js.map