import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import { SinglePage } from "../../../pagination.js";
export declare class CustomPages extends APIResource {
    /**
     * Create a custom page
     */
    create(params: CustomPageCreateParams, options?: Core.RequestOptions): Core.APIPromise<CustomPageWithoutHTML>;
    /**
     * Update a custom page
     */
    update(customPageId: string, params: CustomPageUpdateParams, options?: Core.RequestOptions): Core.APIPromise<CustomPageWithoutHTML>;
    /**
     * List custom pages
     */
    list(params: CustomPageListParams, options?: Core.RequestOptions): Core.PagePromise<CustomPageWithoutHTMLsSinglePage, CustomPageWithoutHTML>;
    /**
     * Delete a custom page
     */
    delete(customPageId: string, params: CustomPageDeleteParams, options?: Core.RequestOptions): Core.APIPromise<CustomPageDeleteResponse>;
    /**
     * Fetches a custom page and also returns its HTML.
     */
    get(customPageId: string, params: CustomPageGetParams, options?: Core.RequestOptions): Core.APIPromise<CustomPage>;
}
export declare class CustomPageWithoutHTMLsSinglePage extends SinglePage<CustomPageWithoutHTML> {
}
export interface CustomPage {
    /**
     * Custom page HTML.
     */
    custom_html: string;
    /**
     * Custom page name.
     */
    name: string;
    /**
     * Custom page type.
     */
    type: 'identity_denied' | 'forbidden';
    /**
     * Number of apps the custom page is assigned to.
     */
    app_count?: number;
    created_at?: string;
    /**
     * UUID
     */
    uid?: string;
    updated_at?: string;
}
export interface CustomPageWithoutHTML {
    /**
     * Custom page name.
     */
    name: string;
    /**
     * Custom page type.
     */
    type: 'identity_denied' | 'forbidden';
    /**
     * Number of apps the custom page is assigned to.
     */
    app_count?: number;
    created_at?: string;
    /**
     * UUID
     */
    uid?: string;
    updated_at?: string;
}
export interface CustomPageDeleteResponse {
    /**
     * UUID
     */
    id?: string;
}
export interface CustomPageCreateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: Custom page HTML.
     */
    custom_html: string;
    /**
     * Body param: Custom page name.
     */
    name: string;
    /**
     * Body param: Custom page type.
     */
    type: 'identity_denied' | 'forbidden';
    /**
     * Body param: Number of apps the custom page is assigned to.
     */
    app_count?: number;
}
export interface CustomPageUpdateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: Custom page HTML.
     */
    custom_html: string;
    /**
     * Body param: Custom page name.
     */
    name: string;
    /**
     * Body param: Custom page type.
     */
    type: 'identity_denied' | 'forbidden';
    /**
     * Body param: Number of apps the custom page is assigned to.
     */
    app_count?: number;
}
export interface CustomPageListParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface CustomPageDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface CustomPageGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace CustomPages {
    export { type CustomPage as CustomPage, type CustomPageWithoutHTML as CustomPageWithoutHTML, type CustomPageDeleteResponse as CustomPageDeleteResponse, CustomPageWithoutHTMLsSinglePage as CustomPageWithoutHTMLsSinglePage, type CustomPageCreateParams as CustomPageCreateParams, type CustomPageUpdateParams as CustomPageUpdateParams, type CustomPageListParams as CustomPageListParams, type CustomPageDeleteParams as CustomPageDeleteParams, type CustomPageGetParams as CustomPageGetParams, };
}
//# sourceMappingURL=custom-pages.d.ts.map