"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomPageWithoutHTMLsSinglePage = exports.CustomPages = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class CustomPages extends resource_1.APIResource {
    /**
     * Create a custom page
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/access/custom_pages`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a custom page
     */
    update(customPageId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/access/custom_pages/${customPageId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List custom pages
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/custom_pages`, CustomPageWithoutHTMLsSinglePage, options);
    }
    /**
     * Delete a custom page
     */
    delete(customPageId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/access/custom_pages/${customPageId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a custom page and also returns its HTML.
     */
    get(customPageId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/access/custom_pages/${customPageId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.CustomPages = CustomPages;
class CustomPageWithoutHTMLsSinglePage extends pagination_1.SinglePage {
}
exports.CustomPageWithoutHTMLsSinglePage = CustomPageWithoutHTMLsSinglePage;
CustomPages.CustomPageWithoutHTMLsSinglePage = CustomPageWithoutHTMLsSinglePage;
//# sourceMappingURL=custom-pages.js.map