import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import { SinglePage } from "../../../pagination.js";
export declare class GatewayCA extends APIResource {
    /**
     * Adds a new SSH Certificate Authority (CA).
     */
    create(params: GatewayCACreateParams, options?: Core.RequestOptions): Core.APIPromise<GatewayCACreateResponse>;
    /**
     * Lists SSH Certificate Authorities (CA).
     */
    list(params: GatewayCAListParams, options?: Core.RequestOptions): Core.PagePromise<GatewayCAListResponsesSinglePage, GatewayCAListResponse>;
    /**
     * Deletes an SSH Certificate Authority.
     */
    delete(certificateId: string, params: GatewayCADeleteParams, options?: Core.RequestOptions): Core.APIPromise<GatewayCADeleteResponse>;
}
export declare class GatewayCAListResponsesSinglePage extends SinglePage<GatewayCAListResponse> {
}
export interface GatewayCACreateResponse {
    /**
     * The key ID of this certificate.
     */
    id?: string;
    /**
     * The public key of this certificate.
     */
    public_key?: string;
}
export interface GatewayCAListResponse {
    /**
     * The key ID of this certificate.
     */
    id?: string;
    /**
     * The public key of this certificate.
     */
    public_key?: string;
}
export interface GatewayCADeleteResponse {
    /**
     * UUID
     */
    id?: string;
}
export interface GatewayCACreateParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface GatewayCAListParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface GatewayCADeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace GatewayCA {
    export { type GatewayCACreateResponse as GatewayCACreateResponse, type GatewayCAListResponse as GatewayCAListResponse, type GatewayCADeleteResponse as GatewayCADeleteResponse, GatewayCAListResponsesSinglePage as GatewayCAListResponsesSinglePage, type GatewayCACreateParams as GatewayCACreateParams, type GatewayCAListParams as GatewayCAListParams, type GatewayCADeleteParams as GatewayCADeleteParams, };
}
//# sourceMappingURL=gateway-ca.d.ts.map