"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.GatewayCAListResponsesSinglePage = exports.GatewayCA = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class GatewayCA extends resource_1.APIResource {
    /**
     * Adds a new SSH Certificate Authority (CA).
     */
    create(params, options) {
        const { account_id } = params;
        return this._client.post(`/accounts/${account_id}/access/gateway_ca`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists SSH Certificate Authorities (CA).
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/gateway_ca`, GatewayCAListResponsesSinglePage, options);
    }
    /**
     * Deletes an SSH Certificate Authority.
     */
    delete(certificateId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/access/gateway_ca/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.GatewayCA = GatewayCA;
class GatewayCAListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.GatewayCAListResponsesSinglePage = GatewayCAListResponsesSinglePage;
GatewayCA.GatewayCAListResponsesSinglePage = GatewayCAListResponsesSinglePage;
//# sourceMappingURL=gateway-ca.js.map