// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class GatewayCA extends APIResource {
    /**
     * Adds a new SSH Certificate Authority (CA).
     */
    create(params, options) {
        const { account_id } = params;
        return this._client.post(`/accounts/${account_id}/access/gateway_ca`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists SSH Certificate Authorities (CA).
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/gateway_ca`, GatewayCAListResponsesSinglePage, options);
    }
    /**
     * Deletes an SSH Certificate Authority.
     */
    delete(certificateId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/access/gateway_ca/${certificateId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class GatewayCAListResponsesSinglePage extends SinglePage {
}
GatewayCA.GatewayCAListResponsesSinglePage = GatewayCAListResponsesSinglePage;
//# sourceMappingURL=gateway-ca.mjs.map