// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import { V4PagePaginationArray } from "../../../../pagination.mjs";
export class Targets extends APIResource {
    /**
     * Create new target
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/infrastructure/targets`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update target
     */
    update(targetId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/infrastructure/targets/${targetId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists and sorts an account’s targets. Filters are optional and are ANDed
     * together.
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/infrastructure/targets`, TargetListResponsesV4PagePaginationArray, { query, ...options });
    }
    /**
     * Delete target
     */
    delete(targetId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/infrastructure/targets/${targetId}`, {
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
    /**
     * Removes one or more targets.
     */
    bulkDelete(params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/infrastructure/targets/batch`, {
            ...options,
            headers: { Accept: '*/*', ...options?.headers },
        });
    }
    /**
     * Adds one or more targets.
     */
    bulkUpdate(params, options) {
        const { account_id, body } = params;
        return this._client.put(`/accounts/${account_id}/infrastructure/targets/batch`, {
            body: body,
            ...options,
        });
    }
    /**
     * Get target
     */
    get(targetId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/infrastructure/targets/${targetId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class TargetListResponsesV4PagePaginationArray extends V4PagePaginationArray {
}
Targets.TargetListResponsesV4PagePaginationArray = TargetListResponsesV4PagePaginationArray;
//# sourceMappingURL=targets.mjs.map