import { APIResource } from "../../../../../resource.js";
import * as UpdatesAPI from "./updates.js";
import { UpdateListParams, UpdateListResponse, UpdateListResponsesSinglePage, Updates } from "./updates.js";
export declare class SCIM extends APIResource {
    updates: UpdatesAPI.Updates;
}
export interface AccessRequest {
    /**
     * The event that occurred, such as a login attempt.
     */
    action?: string;
    /**
     * The result of the authentication event.
     */
    allowed?: boolean;
    /**
     * The URL of the Access application.
     */
    app_domain?: string;
    /**
     * The unique identifier for the Access application.
     */
    app_uid?: string;
    /**
     * The IdP used to authenticate.
     */
    connection?: string;
    created_at?: string;
    /**
     * The IP address of the authenticating user.
     */
    ip_address?: string;
    /**
     * The unique identifier for the request to Cloudflare.
     */
    ray_id?: string;
    /**
     * The email address of the authenticating user.
     */
    user_email?: string;
}
export declare namespace SCIM {
    export { type AccessRequest as AccessRequest };
    export { Updates as Updates, type UpdateListResponse as UpdateListResponse, UpdateListResponsesSinglePage as UpdateListResponsesSinglePage, type UpdateListParams as UpdateListParams, };
}
//# sourceMappingURL=scim.d.ts.map