"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateListResponsesSinglePage = exports.Updates = void 0;
const resource_1 = require("../../../../../resource.js");
const pagination_1 = require("../../../../../pagination.js");
class Updates extends resource_1.APIResource {
    /**
     * Lists Access SCIM update logs that maintain a record of updates made to User and
     * Group resources synced to Cloudflare via the System for Cross-domain Identity
     * Management (SCIM).
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/logs/scim/updates`, UpdateListResponsesSinglePage, { query, ...options });
    }
}
exports.Updates = Updates;
class UpdateListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.UpdateListResponsesSinglePage = UpdateListResponsesSinglePage;
Updates.UpdateListResponsesSinglePage = UpdateListResponsesSinglePage;
//# sourceMappingURL=updates.js.map