// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../../resource.mjs";
import { SinglePage } from "../../../../../pagination.mjs";
export class Updates extends APIResource {
    /**
     * Lists Access SCIM update logs that maintain a record of updates made to User and
     * Group resources synced to Cloudflare via the System for Cross-domain Identity
     * Management (SCIM).
     */
    list(params, options) {
        const { account_id, ...query } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/logs/scim/updates`, UpdateListResponsesSinglePage, { query, ...options });
    }
}
export class UpdateListResponsesSinglePage extends SinglePage {
}
Updates.UpdateListResponsesSinglePage = UpdateListResponsesSinglePage;
//# sourceMappingURL=updates.mjs.map