"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.PolicyListResponsesSinglePage = exports.Policies = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Policies extends resource_1.APIResource {
    /**
     * Creates a new Access reusable policy.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/access/policies`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a Access reusable policy.
     */
    update(policyId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/access/policies/${policyId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists Access reusable policies.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/policies`, PolicyListResponsesSinglePage, options);
    }
    /**
     * Deletes an Access reusable policy.
     */
    delete(policyId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/access/policies/${policyId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single Access reusable policy.
     */
    get(policyId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/access/policies/${policyId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Policies = Policies;
class PolicyListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.PolicyListResponsesSinglePage = PolicyListResponsesSinglePage;
Policies.PolicyListResponsesSinglePage = PolicyListResponsesSinglePage;
//# sourceMappingURL=policies.js.map