// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Policies extends APIResource {
    /**
     * Creates a new Access reusable policy.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/access/policies`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a Access reusable policy.
     */
    update(policyId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/access/policies/${policyId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Lists Access reusable policies.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/policies`, PolicyListResponsesSinglePage, options);
    }
    /**
     * Deletes an Access reusable policy.
     */
    delete(policyId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/access/policies/${policyId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a single Access reusable policy.
     */
    get(policyId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/access/policies/${policyId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class PolicyListResponsesSinglePage extends SinglePage {
}
Policies.PolicyListResponsesSinglePage = PolicyListResponsesSinglePage;
//# sourceMappingURL=policies.mjs.map