"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceTokensSinglePage = exports.ServiceTokens = void 0;
const resource_1 = require("../../../resource.js");
const core_1 = require("../../../core.js");
const error_1 = require("../../../error.js");
const pagination_1 = require("../../../pagination.js");
class ServiceTokens extends resource_1.APIResource {
    /**
     * Generates a new service token. **Note:** This is the only time you can get the
     * Client Secret. If you lose the Client Secret, you will have to rotate the Client
     * Secret or create a new service token.
     */
    create(params, options) {
        const { account_id, zone_id, ...body } = params;
        if (!account_id && !zone_id) {
            throw new error_1.CloudflareError('You must provide either account_id or zone_id.');
        }
        if (account_id && zone_id) {
            throw new error_1.CloudflareError('You cannot provide both account_id and zone_id.');
        }
        const { accountOrZone, accountOrZoneId } = account_id ?
            {
                accountOrZone: 'accounts',
                accountOrZoneId: account_id,
            }
            : {
                accountOrZone: 'zones',
                accountOrZoneId: zone_id,
            };
        return this._client.post(`/${accountOrZone}/${accountOrZoneId}/access/service_tokens`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a configured service token.
     */
    update(serviceTokenId, params, options) {
        const { account_id, zone_id, ...body } = params;
        if (!account_id && !zone_id) {
            throw new error_1.CloudflareError('You must provide either account_id or zone_id.');
        }
        if (account_id && zone_id) {
            throw new error_1.CloudflareError('You cannot provide both account_id and zone_id.');
        }
        const { accountOrZone, accountOrZoneId } = account_id ?
            {
                accountOrZone: 'accounts',
                accountOrZoneId: account_id,
            }
            : {
                accountOrZone: 'zones',
                accountOrZoneId: zone_id,
            };
        return this._client.put(`/${accountOrZone}/${accountOrZoneId}/access/service_tokens/${serviceTokenId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    list(params = {}, options) {
        if ((0, core_1.isRequestOptions)(params)) {
            return this.list({}, params);
        }
        const { account_id, zone_id, ...query } = params;
        if (!account_id && !zone_id) {
            throw new error_1.CloudflareError('You must provide either account_id or zone_id.');
        }
        if (account_id && zone_id) {
            throw new error_1.CloudflareError('You cannot provide both account_id and zone_id.');
        }
        const { accountOrZone, accountOrZoneId } = account_id ?
            {
                accountOrZone: 'accounts',
                accountOrZoneId: account_id,
            }
            : {
                accountOrZone: 'zones',
                accountOrZoneId: zone_id,
            };
        return this._client.getAPIList(`/${accountOrZone}/${accountOrZoneId}/access/service_tokens`, ServiceTokensSinglePage, { query, ...options });
    }
    delete(serviceTokenId, params = {}, options) {
        if ((0, core_1.isRequestOptions)(params)) {
            return this.delete(serviceTokenId, {}, params);
        }
        const { account_id, zone_id } = params;
        if (!account_id && !zone_id) {
            throw new error_1.CloudflareError('You must provide either account_id or zone_id.');
        }
        if (account_id && zone_id) {
            throw new error_1.CloudflareError('You cannot provide both account_id and zone_id.');
        }
        const { accountOrZone, accountOrZoneId } = account_id ?
            {
                accountOrZone: 'accounts',
                accountOrZoneId: account_id,
            }
            : {
                accountOrZone: 'zones',
                accountOrZoneId: zone_id,
            };
        return this._client.delete(`/${accountOrZone}/${accountOrZoneId}/access/service_tokens/${serviceTokenId}`, options)._thenUnwrap((obj) => obj.result);
    }
    get(serviceTokenId, params = {}, options) {
        if ((0, core_1.isRequestOptions)(params)) {
            return this.get(serviceTokenId, {}, params);
        }
        const { account_id, zone_id } = params;
        if (!account_id && !zone_id) {
            throw new error_1.CloudflareError('You must provide either account_id or zone_id.');
        }
        if (account_id && zone_id) {
            throw new error_1.CloudflareError('You cannot provide both account_id and zone_id.');
        }
        const { accountOrZone, accountOrZoneId } = account_id ?
            {
                accountOrZone: 'accounts',
                accountOrZoneId: account_id,
            }
            : {
                accountOrZone: 'zones',
                accountOrZoneId: zone_id,
            };
        return this._client.get(`/${accountOrZone}/${accountOrZoneId}/access/service_tokens/${serviceTokenId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Refreshes the expiration of a service token.
     */
    refresh(serviceTokenId, params, options) {
        const { account_id } = params;
        return this._client.post(`/accounts/${account_id}/access/service_tokens/${serviceTokenId}/refresh`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Generates a new Client Secret for a service token and revokes the old one.
     */
    rotate(serviceTokenId, params, options) {
        const { account_id } = params;
        return this._client.post(`/accounts/${account_id}/access/service_tokens/${serviceTokenId}/rotate`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.ServiceTokens = ServiceTokens;
class ServiceTokensSinglePage extends pagination_1.SinglePage {
}
exports.ServiceTokensSinglePage = ServiceTokensSinglePage;
ServiceTokens.ServiceTokensSinglePage = ServiceTokensSinglePage;
//# sourceMappingURL=service-tokens.js.map