import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import { SinglePage } from "../../../pagination.js";
export declare class Tags extends APIResource {
    /**
     * Create a tag
     */
    create(params: TagCreateParams, options?: Core.RequestOptions): Core.APIPromise<Tag>;
    /**
     * Update a tag
     */
    update(tagName: string, params: TagUpdateParams, options?: Core.RequestOptions): Core.APIPromise<Tag>;
    /**
     * List tags
     */
    list(params: TagListParams, options?: Core.RequestOptions): Core.PagePromise<TagsSinglePage, Tag>;
    /**
     * Delete a tag
     */
    delete(tagName: string, params: TagDeleteParams, options?: Core.RequestOptions): Core.APIPromise<TagDeleteResponse>;
    /**
     * Get a tag
     */
    get(tagName: string, params: TagGetParams, options?: Core.RequestOptions): Core.APIPromise<Tag>;
}
export declare class TagsSinglePage extends SinglePage<Tag> {
}
/**
 * A tag
 */
export interface Tag {
    /**
     * The name of the tag
     */
    name: string;
    /**
     * The number of applications that have this tag
     */
    app_count?: number;
    created_at?: string;
    updated_at?: string;
}
export interface TagDeleteResponse {
    /**
     * The name of the tag
     */
    name?: string;
}
export interface TagCreateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: The name of the tag
     */
    name?: string;
}
export interface TagUpdateParams {
    /**
     * Path param: Identifier
     */
    account_id: string;
    /**
     * Body param: The name of the tag
     */
    name: string;
}
export interface TagListParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface TagDeleteParams {
    /**
     * Identifier
     */
    account_id: string;
}
export interface TagGetParams {
    /**
     * Identifier
     */
    account_id: string;
}
export declare namespace Tags {
    export { type Tag as Tag, type TagDeleteResponse as TagDeleteResponse, TagsSinglePage as TagsSinglePage, type TagCreateParams as TagCreateParams, type TagUpdateParams as TagUpdateParams, type TagListParams as TagListParams, type TagDeleteParams as TagDeleteParams, type TagGetParams as TagGetParams, };
}
//# sourceMappingURL=tags.d.ts.map