"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.TagsSinglePage = exports.Tags = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class Tags extends resource_1.APIResource {
    /**
     * Create a tag
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/access/tags`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a tag
     */
    update(tagName, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/access/tags/${tagName}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List tags
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/tags`, TagsSinglePage, options);
    }
    /**
     * Delete a tag
     */
    delete(tagName, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/access/tags/${tagName}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a tag
     */
    get(tagName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/access/tags/${tagName}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Tags = Tags;
class TagsSinglePage extends pagination_1.SinglePage {
}
exports.TagsSinglePage = TagsSinglePage;
Tags.TagsSinglePage = TagsSinglePage;
//# sourceMappingURL=tags.js.map