// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Tags extends APIResource {
    /**
     * Create a tag
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/access/tags`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a tag
     */
    update(tagName, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/access/tags/${tagName}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * List tags
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/tags`, TagsSinglePage, options);
    }
    /**
     * Delete a tag
     */
    delete(tagName, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/access/tags/${tagName}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Get a tag
     */
    get(tagName, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/access/tags/${tagName}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class TagsSinglePage extends SinglePage {
}
Tags.TagsSinglePage = TagsSinglePage;
//# sourceMappingURL=tags.mjs.map