"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActiveSessionListResponsesSinglePage = exports.ActiveSessions = void 0;
const resource_1 = require("../../../../resource.js");
const pagination_1 = require("../../../../pagination.js");
class ActiveSessions extends resource_1.APIResource {
    /**
     * Get active sessions for a single user.
     */
    list(userId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/users/${userId}/active_sessions`, ActiveSessionListResponsesSinglePage, options);
    }
    /**
     * Get an active session for a single user.
     */
    get(userId, nonce, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/access/users/${userId}/active_sessions/${nonce}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.ActiveSessions = ActiveSessions;
class ActiveSessionListResponsesSinglePage extends pagination_1.SinglePage {
}
exports.ActiveSessionListResponsesSinglePage = ActiveSessionListResponsesSinglePage;
ActiveSessions.ActiveSessionListResponsesSinglePage = ActiveSessionListResponsesSinglePage;
//# sourceMappingURL=active-sessions.js.map