// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../../resource.mjs";
import { SinglePage } from "../../../../pagination.mjs";
export class ActiveSessions extends APIResource {
    /**
     * Get active sessions for a single user.
     */
    list(userId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/access/users/${userId}/active_sessions`, ActiveSessionListResponsesSinglePage, options);
    }
    /**
     * Get an active session for a single user.
     */
    get(userId, nonce, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/access/users/${userId}/active_sessions/${nonce}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class ActiveSessionListResponsesSinglePage extends SinglePage {
}
ActiveSessions.ActiveSessionListResponsesSinglePage = ActiveSessionListResponsesSinglePage;
//# sourceMappingURL=active-sessions.mjs.map