import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import { SinglePage } from "../../../pagination.js";
export declare class DEXTests extends APIResource {
    /**
     * Create a DEX test.
     */
    create(params: DEXTestCreateParams, options?: Core.RequestOptions): Core.APIPromise<SchemaHTTP | null>;
    /**
     * Update a DEX test.
     */
    update(dexTestId: string, params: DEXTestUpdateParams, options?: Core.RequestOptions): Core.APIPromise<SchemaHTTP | null>;
    /**
     * Fetch all DEX tests.
     */
    list(params: DEXTestListParams, options?: Core.RequestOptions): Core.PagePromise<SchemaHTTPSSinglePage, SchemaHTTP>;
    /**
     * Delete a Device DEX test. Returns the remaining device dex tests for the
     * account.
     */
    delete(dexTestId: string, params: DEXTestDeleteParams, options?: Core.RequestOptions): Core.APIPromise<DEXTestDeleteResponse>;
    /**
     * Fetch a single DEX test.
     */
    get(dexTestId: string, params: DEXTestGetParams, options?: Core.RequestOptions): Core.APIPromise<SchemaHTTP | null>;
}
export declare class SchemaHTTPSSinglePage extends SinglePage<SchemaHTTP> {
}
export interface DEXTest {
    /**
     * The configuration object which contains the details for the WARP client to
     * conduct the test.
     */
    data: SchemaData;
    /**
     * Determines whether or not the test is active.
     */
    enabled: boolean;
    /**
     * How often the test will run.
     */
    interval: string;
    /**
     * The name of the DEX test. Must be unique.
     */
    name: string;
    /**
     * Additional details about the test.
     */
    description?: string;
    /**
     * Device settings profiles targeted by this test
     */
    target_policies?: Array<DEXTest.TargetPolicy>;
    targeted?: boolean;
    /**
     * The unique identifier for the test.
     */
    test_id?: string;
}
export declare namespace DEXTest {
    interface TargetPolicy {
        /**
         * The id of the device settings profile
         */
        id?: string;
        /**
         * Whether the profile is the account default
         */
        default?: boolean;
        /**
         * The name of the device settings profile
         */
        name?: string;
    }
}
/**
 * The configuration object which contains the details for the WARP client to
 * conduct the test.
 */
export interface SchemaData {
    /**
     * The desired endpoint to test.
     */
    host?: string;
    /**
     * The type of test.
     */
    kind?: string;
    /**
     * The HTTP request method type.
     */
    method?: string;
}
/**
 * The configuration object which contains the details for the WARP client to
 * conduct the test.
 */
export interface SchemaDataParam {
    /**
     * The desired endpoint to test.
     */
    host?: string;
    /**
     * The type of test.
     */
    kind?: string;
    /**
     * The HTTP request method type.
     */
    method?: string;
}
export interface SchemaHTTP {
    /**
     * The configuration object which contains the details for the WARP client to
     * conduct the test.
     */
    data: SchemaData;
    /**
     * Determines whether or not the test is active.
     */
    enabled: boolean;
    /**
     * How often the test will run.
     */
    interval: string;
    /**
     * The name of the DEX test. Must be unique.
     */
    name: string;
    /**
     * Additional details about the test.
     */
    description?: string;
    /**
     * Device settings profiles targeted by this test
     */
    target_policies?: Array<SchemaHTTP.TargetPolicy>;
    targeted?: boolean;
    /**
     * The unique identifier for the test.
     */
    test_id?: string;
}
export declare namespace SchemaHTTP {
    interface TargetPolicy {
        /**
         * The id of the device settings profile
         */
        id?: string;
        /**
         * Whether the profile is the account default
         */
        default?: boolean;
        /**
         * The name of the device settings profile
         */
        name?: string;
    }
}
export interface DEXTestDeleteResponse {
    dex_tests?: Array<SchemaHTTP>;
}
export interface DEXTestCreateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param: The configuration object which contains the details for the WARP
     * client to conduct the test.
     */
    data: SchemaDataParam;
    /**
     * Body param: Determines whether or not the test is active.
     */
    enabled: boolean;
    /**
     * Body param: How often the test will run.
     */
    interval: string;
    /**
     * Body param: The name of the DEX test. Must be unique.
     */
    name: string;
    /**
     * Body param: Additional details about the test.
     */
    description?: string;
    /**
     * Body param: Device settings profiles targeted by this test
     */
    target_policies?: Array<DEXTestCreateParams.TargetPolicy>;
    /**
     * Body param:
     */
    targeted?: boolean;
}
export declare namespace DEXTestCreateParams {
    interface TargetPolicy {
        /**
         * The id of the device settings profile
         */
        id?: string;
        /**
         * Whether the profile is the account default
         */
        default?: boolean;
        /**
         * The name of the device settings profile
         */
        name?: string;
    }
}
export interface DEXTestUpdateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param: The configuration object which contains the details for the WARP
     * client to conduct the test.
     */
    data: SchemaDataParam;
    /**
     * Body param: Determines whether or not the test is active.
     */
    enabled: boolean;
    /**
     * Body param: How often the test will run.
     */
    interval: string;
    /**
     * Body param: The name of the DEX test. Must be unique.
     */
    name: string;
    /**
     * Body param: Additional details about the test.
     */
    description?: string;
    /**
     * Body param: Device settings profiles targeted by this test
     */
    target_policies?: Array<DEXTestUpdateParams.TargetPolicy>;
    /**
     * Body param:
     */
    targeted?: boolean;
}
export declare namespace DEXTestUpdateParams {
    interface TargetPolicy {
        /**
         * The id of the device settings profile
         */
        id?: string;
        /**
         * Whether the profile is the account default
         */
        default?: boolean;
        /**
         * The name of the device settings profile
         */
        name?: string;
    }
}
export interface DEXTestListParams {
    account_id: string;
}
export interface DEXTestDeleteParams {
    account_id: string;
}
export interface DEXTestGetParams {
    account_id: string;
}
export declare namespace DEXTests {
    export { type DEXTest as DEXTest, type SchemaData as SchemaData, type SchemaHTTP as SchemaHTTP, type DEXTestDeleteResponse as DEXTestDeleteResponse, SchemaHTTPSSinglePage as SchemaHTTPSSinglePage, type DEXTestCreateParams as DEXTestCreateParams, type DEXTestUpdateParams as DEXTestUpdateParams, type DEXTestListParams as DEXTestListParams, type DEXTestDeleteParams as DEXTestDeleteParams, type DEXTestGetParams as DEXTestGetParams, };
}
//# sourceMappingURL=dex-tests.d.ts.map