"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.SchemaHTTPSSinglePage = exports.DEXTests = void 0;
const resource_1 = require("../../../resource.js");
const pagination_1 = require("../../../pagination.js");
class DEXTests extends resource_1.APIResource {
    /**
     * Create a DEX test.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/devices/dex_tests`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a DEX test.
     */
    update(dexTestId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/devices/dex_tests/${dexTestId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch all DEX tests.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/dex_tests`, SchemaHTTPSSinglePage, options);
    }
    /**
     * Delete a Device DEX test. Returns the remaining device dex tests for the
     * account.
     */
    delete(dexTestId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/devices/dex_tests/${dexTestId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a single DEX test.
     */
    get(dexTestId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/devices/dex_tests/${dexTestId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.DEXTests = DEXTests;
class SchemaHTTPSSinglePage extends pagination_1.SinglePage {
}
exports.SchemaHTTPSSinglePage = SchemaHTTPSSinglePage;
DEXTests.SchemaHTTPSSinglePage = SchemaHTTPSSinglePage;
//# sourceMappingURL=dex-tests.js.map