// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class DEXTests extends APIResource {
    /**
     * Create a DEX test.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/devices/dex_tests`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Update a DEX test.
     */
    update(dexTestId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/devices/dex_tests/${dexTestId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch all DEX tests.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/dex_tests`, SchemaHTTPSSinglePage, options);
    }
    /**
     * Delete a Device DEX test. Returns the remaining device dex tests for the
     * account.
     */
    delete(dexTestId, params, options) {
        const { account_id } = params;
        return this._client.delete(`/accounts/${account_id}/devices/dex_tests/${dexTestId}`, options)._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetch a single DEX test.
     */
    get(dexTestId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/devices/dex_tests/${dexTestId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class SchemaHTTPSSinglePage extends SinglePage {
}
DEXTests.SchemaHTTPSSinglePage = SchemaHTTPSSinglePage;
//# sourceMappingURL=dex-tests.mjs.map