import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
export declare class FleetStatus extends APIResource {
    /**
     * Get the live status of a latest device given device_id from the device_state
     * table
     */
    get(deviceId: string, params: FleetStatusGetParams, options?: Core.RequestOptions): Core.APIPromise<FleetStatusGetResponse>;
}
export interface FleetStatusGetResponse {
    /**
     * Cloudflare colo
     */
    colo: string;
    /**
     * Device identifier (UUID v4)
     */
    deviceId: string;
    /**
     * The mode under which the WARP client is run
     */
    mode: string;
    /**
     * Operating system
     */
    platform: string;
    /**
     * Network status
     */
    status: string;
    /**
     * Timestamp in ISO format
     */
    timestamp: string;
    /**
     * WARP client version
     */
    version: string;
    alwaysOn?: boolean | null;
    batteryCharging?: boolean | null;
    batteryCycles?: number | null;
    batteryPct?: number | null;
    connectionType?: string | null;
    cpuPct?: number | null;
    cpuPctByApp?: Array<Array<FleetStatusGetResponse.CPUPctByApp>> | null;
    deviceIpv4?: FleetStatusGetResponse.DeviceIPV4;
    deviceIpv6?: FleetStatusGetResponse.DeviceIPV6;
    /**
     * Device identifier (human readable)
     */
    deviceName?: string;
    diskReadBps?: number | null;
    diskUsagePct?: number | null;
    diskWriteBps?: number | null;
    dohSubdomain?: string | null;
    estimatedLossPct?: number | null;
    firewallEnabled?: boolean | null;
    gatewayIpv4?: FleetStatusGetResponse.GatewayIPV4;
    gatewayIpv6?: FleetStatusGetResponse.GatewayIPV6;
    handshakeLatencyMs?: number | null;
    ispIpv4?: FleetStatusGetResponse.ISPIPV4;
    ispIpv6?: FleetStatusGetResponse.ISPIPV6;
    metal?: string | null;
    networkRcvdBps?: number | null;
    networkSentBps?: number | null;
    networkSsid?: string | null;
    /**
     * User contact email address
     */
    personEmail?: string;
    ramAvailableKb?: number | null;
    ramUsedPct?: number | null;
    ramUsedPctByApp?: Array<Array<FleetStatusGetResponse.RamUsedPctByApp>> | null;
    switchLocked?: boolean | null;
    wifiStrengthDbm?: number | null;
}
export declare namespace FleetStatusGetResponse {
    interface CPUPctByApp {
        cpu_pct?: number;
        name?: string;
    }
    interface DeviceIPV4 {
        address?: string | null;
        asn?: number | null;
        aso?: string | null;
        location?: DeviceIPV4.Location;
        netmask?: string | null;
        version?: string | null;
    }
    namespace DeviceIPV4 {
        interface Location {
            city?: string | null;
            country_iso?: string | null;
            state_iso?: string | null;
            zip?: string | null;
        }
    }
    interface DeviceIPV6 {
        address?: string | null;
        asn?: number | null;
        aso?: string | null;
        location?: DeviceIPV6.Location;
        netmask?: string | null;
        version?: string | null;
    }
    namespace DeviceIPV6 {
        interface Location {
            city?: string | null;
            country_iso?: string | null;
            state_iso?: string | null;
            zip?: string | null;
        }
    }
    interface GatewayIPV4 {
        address?: string | null;
        asn?: number | null;
        aso?: string | null;
        location?: GatewayIPV4.Location;
        netmask?: string | null;
        version?: string | null;
    }
    namespace GatewayIPV4 {
        interface Location {
            city?: string | null;
            country_iso?: string | null;
            state_iso?: string | null;
            zip?: string | null;
        }
    }
    interface GatewayIPV6 {
        address?: string | null;
        asn?: number | null;
        aso?: string | null;
        location?: GatewayIPV6.Location;
        netmask?: string | null;
        version?: string | null;
    }
    namespace GatewayIPV6 {
        interface Location {
            city?: string | null;
            country_iso?: string | null;
            state_iso?: string | null;
            zip?: string | null;
        }
    }
    interface ISPIPV4 {
        address?: string | null;
        asn?: number | null;
        aso?: string | null;
        location?: ISPIPV4.Location;
        netmask?: string | null;
        version?: string | null;
    }
    namespace ISPIPV4 {
        interface Location {
            city?: string | null;
            country_iso?: string | null;
            state_iso?: string | null;
            zip?: string | null;
        }
    }
    interface ISPIPV6 {
        address?: string | null;
        asn?: number | null;
        aso?: string | null;
        location?: ISPIPV6.Location;
        netmask?: string | null;
        version?: string | null;
    }
    namespace ISPIPV6 {
        interface Location {
            city?: string | null;
            country_iso?: string | null;
            state_iso?: string | null;
            zip?: string | null;
        }
    }
    interface RamUsedPctByApp {
        name?: string;
        ram_used_pct?: number;
    }
}
export interface FleetStatusGetParams {
    /**
     * Path param: Unique identifier for account
     */
    account_id: string;
    /**
     * Query param: Number of minutes before current time
     */
    since_minutes: number;
    /**
     * Query param: List of data centers to filter results
     */
    colo?: string;
    /**
     * Query param: Number of minutes before current time
     */
    time_now?: string;
}
export declare namespace FleetStatus {
    export { type FleetStatusGetResponse as FleetStatusGetResponse, type FleetStatusGetParams as FleetStatusGetParams, };
}
//# sourceMappingURL=fleet-status.d.ts.map