import { APIResource } from "../../../resource.js";
import * as Core from "../../../core.js";
import { SinglePage } from "../../../pagination.js";
export declare class Networks extends APIResource {
    /**
     * Creates a new device managed network.
     */
    create(params: NetworkCreateParams, options?: Core.RequestOptions): Core.APIPromise<DeviceNetwork | null>;
    /**
     * Updates a configured device managed network.
     */
    update(networkId: string, params: NetworkUpdateParams, options?: Core.RequestOptions): Core.APIPromise<DeviceNetwork | null>;
    /**
     * Fetches a list of managed networks for an account.
     */
    list(params: NetworkListParams, options?: Core.RequestOptions): Core.PagePromise<DeviceNetworksSinglePage, DeviceNetwork>;
    /**
     * Deletes a device managed network and fetches a list of the remaining device
     * managed networks for an account.
     */
    delete(networkId: string, params: NetworkDeleteParams, options?: Core.RequestOptions): Core.PagePromise<DeviceNetworksSinglePage, DeviceNetwork>;
    /**
     * Fetches details for a single managed network.
     */
    get(networkId: string, params: NetworkGetParams, options?: Core.RequestOptions): Core.APIPromise<DeviceNetwork | null>;
}
export declare class DeviceNetworksSinglePage extends SinglePage<DeviceNetwork> {
}
export interface DeviceNetwork {
    /**
     * The configuration object containing information for the WARP client to detect
     * the managed network.
     */
    config?: DeviceNetwork.Config;
    /**
     * The name of the device managed network. This name must be unique.
     */
    name?: string;
    /**
     * API UUID.
     */
    network_id?: string;
    /**
     * The type of device managed network.
     */
    type?: 'tls';
}
export declare namespace DeviceNetwork {
    /**
     * The configuration object containing information for the WARP client to detect
     * the managed network.
     */
    interface Config {
        /**
         * A network address of the form "host:port" that the WARP client will use to
         * detect the presence of a TLS host.
         */
        tls_sockaddr: string;
        /**
         * The SHA-256 hash of the TLS certificate presented by the host found at
         * tls_sockaddr. If absent, regular certificate verification (trusted roots, valid
         * timestamp, etc) will be used to validate the certificate.
         */
        sha256?: string;
    }
}
export interface NetworkCreateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param: The configuration object containing information for the WARP client
     * to detect the managed network.
     */
    config: NetworkCreateParams.Config;
    /**
     * Body param: The name of the device managed network. This name must be unique.
     */
    name: string;
    /**
     * Body param: The type of device managed network.
     */
    type: 'tls';
}
export declare namespace NetworkCreateParams {
    /**
     * The configuration object containing information for the WARP client to detect
     * the managed network.
     */
    interface Config {
        /**
         * A network address of the form "host:port" that the WARP client will use to
         * detect the presence of a TLS host.
         */
        tls_sockaddr: string;
        /**
         * The SHA-256 hash of the TLS certificate presented by the host found at
         * tls_sockaddr. If absent, regular certificate verification (trusted roots, valid
         * timestamp, etc) will be used to validate the certificate.
         */
        sha256?: string;
    }
}
export interface NetworkUpdateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param: The configuration object containing information for the WARP client
     * to detect the managed network.
     */
    config?: NetworkUpdateParams.Config;
    /**
     * Body param: The name of the device managed network. This name must be unique.
     */
    name?: string;
    /**
     * Body param: The type of device managed network.
     */
    type?: 'tls';
}
export declare namespace NetworkUpdateParams {
    /**
     * The configuration object containing information for the WARP client to detect
     * the managed network.
     */
    interface Config {
        /**
         * A network address of the form "host:port" that the WARP client will use to
         * detect the presence of a TLS host.
         */
        tls_sockaddr: string;
        /**
         * The SHA-256 hash of the TLS certificate presented by the host found at
         * tls_sockaddr. If absent, regular certificate verification (trusted roots, valid
         * timestamp, etc) will be used to validate the certificate.
         */
        sha256?: string;
    }
}
export interface NetworkListParams {
    account_id: string;
}
export interface NetworkDeleteParams {
    account_id: string;
}
export interface NetworkGetParams {
    account_id: string;
}
export declare namespace Networks {
    export { type DeviceNetwork as DeviceNetwork, DeviceNetworksSinglePage as DeviceNetworksSinglePage, type NetworkCreateParams as NetworkCreateParams, type NetworkUpdateParams as NetworkUpdateParams, type NetworkListParams as NetworkListParams, type NetworkDeleteParams as NetworkDeleteParams, type NetworkGetParams as NetworkGetParams, };
}
//# sourceMappingURL=networks.d.ts.map