// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
import { APIResource } from "../../../resource.mjs";
import { SinglePage } from "../../../pagination.mjs";
export class Networks extends APIResource {
    /**
     * Creates a new device managed network.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/devices/networks`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Updates a configured device managed network.
     */
    update(networkId, params, options) {
        const { account_id, ...body } = params;
        return this._client.put(`/accounts/${account_id}/devices/networks/${networkId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a list of managed networks for an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/networks`, DeviceNetworksSinglePage, options);
    }
    /**
     * Deletes a device managed network and fetches a list of the remaining device
     * managed networks for an account.
     */
    delete(networkId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/networks/${networkId}`, DeviceNetworksSinglePage, { method: 'delete', ...options });
    }
    /**
     * Fetches details for a single managed network.
     */
    get(networkId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/devices/networks/${networkId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
export class DeviceNetworksSinglePage extends SinglePage {
}
Networks.DeviceNetworksSinglePage = DeviceNetworksSinglePage;
//# sourceMappingURL=networks.mjs.map