"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
Object.defineProperty(exports, "__esModule", { value: true });
exports.OverrideCodes = void 0;
const resource_1 = require("../../../resource.js");
class OverrideCodes extends resource_1.APIResource {
    /**
     * Fetches a one-time use admin override code for a device. This relies on the
     * **Admin Override** setting being enabled in your device configuration.
     */
    list(deviceId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/devices/${deviceId}/override_codes`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.OverrideCodes = OverrideCodes;
//# sourceMappingURL=override-codes.js.map