import { APIResource } from "../../../../../resource.js";
import * as Core from "../../../../../core.js";
import * as PoliciesAPI from "../policies.js";
import { SettingsPoliciesSinglePage } from "../policies.js";
import * as ExcludesAPI from "./excludes.js";
import { ExcludeGetParams, ExcludeUpdateParams, Excludes } from "./excludes.js";
import * as FallbackDomainsAPI from "./fallback-domains.js";
import { FallbackDomainGetParams, FallbackDomainUpdateParams, FallbackDomains } from "./fallback-domains.js";
import * as IncludesAPI from "./includes.js";
import { IncludeGetParams, IncludeUpdateParams, Includes } from "./includes.js";
export declare class Custom extends APIResource {
    excludes: ExcludesAPI.Excludes;
    includes: IncludesAPI.Includes;
    fallbackDomains: FallbackDomainsAPI.FallbackDomains;
    /**
     * Creates a device settings profile to be applied to certain devices matching the
     * criteria.
     */
    create(params: CustomCreateParams, options?: Core.RequestOptions): Core.APIPromise<PoliciesAPI.SettingsPolicy | null>;
    /**
     * Fetches a list of the device settings profiles for an account.
     */
    list(params: CustomListParams, options?: Core.RequestOptions): Core.PagePromise<SettingsPoliciesSinglePage, PoliciesAPI.SettingsPolicy>;
    /**
     * Deletes a device settings profile and fetches a list of the remaining profiles
     * for an account.
     */
    delete(policyId: string, params: CustomDeleteParams, options?: Core.RequestOptions): Core.PagePromise<SettingsPoliciesSinglePage, PoliciesAPI.SettingsPolicy>;
    /**
     * Updates a configured device settings profile.
     */
    edit(policyId: string, params: CustomEditParams, options?: Core.RequestOptions): Core.APIPromise<PoliciesAPI.SettingsPolicy | null>;
    /**
     * Fetches a device settings profile by ID.
     */
    get(policyId: string, params: CustomGetParams, options?: Core.RequestOptions): Core.APIPromise<PoliciesAPI.SettingsPolicy | null>;
}
export interface CustomCreateParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param: The wirefilter expression to match devices.
     */
    match: string;
    /**
     * Body param: The name of the device settings profile.
     */
    name: string;
    /**
     * Body param: The precedence of the policy. Lower values indicate higher
     * precedence. Policies will be evaluated in ascending order of this field.
     */
    precedence: number;
    /**
     * Body param: Whether to allow the user to switch WARP between modes.
     */
    allow_mode_switch?: boolean;
    /**
     * Body param: Whether to receive update notifications when a new version of the
     * client is available.
     */
    allow_updates?: boolean;
    /**
     * Body param: Whether to allow devices to leave the organization.
     */
    allowed_to_leave?: boolean;
    /**
     * Body param: The amount of time in seconds to reconnect after having been
     * disabled.
     */
    auto_connect?: number;
    /**
     * Body param: Turn on the captive portal after the specified amount of time.
     */
    captive_portal?: number;
    /**
     * Body param: A description of the policy.
     */
    description?: string;
    /**
     * Body param: If the `dns_server` field of a fallback domain is not present, the
     * client will fall back to a best guess of the default/system DNS resolvers unless
     * this policy option is set to `true`.
     */
    disable_auto_fallback?: boolean;
    /**
     * Body param: Whether the policy will be applied to matching devices.
     */
    enabled?: boolean;
    /**
     * Body param: List of routes excluded in the WARP client's tunnel. Both 'exclude'
     * and 'include' cannot be set in the same request.
     */
    exclude?: Array<PoliciesAPI.SplitTunnelExcludeParam>;
    /**
     * Body param: Whether to add Microsoft IPs to Split Tunnel exclusions.
     */
    exclude_office_ips?: boolean;
    /**
     * Body param: List of routes included in the WARP client's tunnel. Both 'exclude'
     * and 'include' cannot be set in the same request.
     */
    include?: Array<PoliciesAPI.SplitTunnelExcludeParam>;
    /**
     * Body param: The amount of time in minutes a user is allowed access to their LAN.
     * A value of 0 will allow LAN access until the next WARP reconnection, such as a
     * reboot or a laptop waking from sleep. Note that this field is omitted from the
     * response if null or unset.
     */
    lan_allow_minutes?: number;
    /**
     * Body param: The size of the subnet for the local access network. Note that this
     * field is omitted from the response if null or unset.
     */
    lan_allow_subnet_size?: number;
    /**
     * Body param: Determines if the operating system will register WARP's local
     * interface IP with your on-premises DNS server.
     */
    register_interface_ip_with_dns?: boolean;
    /**
     * Body param:
     */
    service_mode_v2?: CustomCreateParams.ServiceModeV2;
    /**
     * Body param: The URL to launch when the Send Feedback button is clicked.
     */
    support_url?: string;
    /**
     * Body param: Whether to allow the user to turn off the WARP switch and disconnect
     * the client.
     */
    switch_locked?: boolean;
    /**
     * Body param: Determines which tunnel protocol to use.
     */
    tunnel_protocol?: string;
}
export declare namespace CustomCreateParams {
    interface ServiceModeV2 {
        /**
         * The mode to run the WARP client under.
         */
        mode?: string;
        /**
         * The port number when used with proxy mode.
         */
        port?: number;
    }
}
export interface CustomListParams {
    account_id: string;
}
export interface CustomDeleteParams {
    account_id: string;
}
export interface CustomEditParams {
    /**
     * Path param:
     */
    account_id: string;
    /**
     * Body param: Whether to allow the user to switch WARP between modes.
     */
    allow_mode_switch?: boolean;
    /**
     * Body param: Whether to receive update notifications when a new version of the
     * client is available.
     */
    allow_updates?: boolean;
    /**
     * Body param: Whether to allow devices to leave the organization.
     */
    allowed_to_leave?: boolean;
    /**
     * Body param: The amount of time in seconds to reconnect after having been
     * disabled.
     */
    auto_connect?: number;
    /**
     * Body param: Turn on the captive portal after the specified amount of time.
     */
    captive_portal?: number;
    /**
     * Body param: A description of the policy.
     */
    description?: string;
    /**
     * Body param: If the `dns_server` field of a fallback domain is not present, the
     * client will fall back to a best guess of the default/system DNS resolvers unless
     * this policy option is set to `true`.
     */
    disable_auto_fallback?: boolean;
    /**
     * Body param: Whether the policy will be applied to matching devices.
     */
    enabled?: boolean;
    /**
     * Body param: List of routes excluded in the WARP client's tunnel. Both 'exclude'
     * and 'include' cannot be set in the same request.
     */
    exclude?: Array<PoliciesAPI.SplitTunnelExcludeParam>;
    /**
     * Body param: Whether to add Microsoft IPs to Split Tunnel exclusions.
     */
    exclude_office_ips?: boolean;
    /**
     * Body param: List of routes included in the WARP client's tunnel. Both 'exclude'
     * and 'include' cannot be set in the same request.
     */
    include?: Array<PoliciesAPI.SplitTunnelExcludeParam>;
    /**
     * Body param: The wirefilter expression to match devices.
     */
    match?: string;
    /**
     * Body param: The name of the device settings profile.
     */
    name?: string;
    /**
     * Body param: The precedence of the policy. Lower values indicate higher
     * precedence. Policies will be evaluated in ascending order of this field.
     */
    precedence?: number;
    /**
     * Body param: Determines if the operating system will register WARP's local
     * interface IP with your on-premises DNS server.
     */
    register_interface_ip_with_dns?: boolean;
    /**
     * Body param:
     */
    service_mode_v2?: CustomEditParams.ServiceModeV2;
    /**
     * Body param: The URL to launch when the Send Feedback button is clicked.
     */
    support_url?: string;
    /**
     * Body param: Whether to allow the user to turn off the WARP switch and disconnect
     * the client.
     */
    switch_locked?: boolean;
    /**
     * Body param: Determines which tunnel protocol to use.
     */
    tunnel_protocol?: string;
}
export declare namespace CustomEditParams {
    interface ServiceModeV2 {
        /**
         * The mode to run the WARP client under.
         */
        mode?: string;
        /**
         * The port number when used with proxy mode.
         */
        port?: number;
    }
}
export interface CustomGetParams {
    account_id: string;
}
export declare namespace Custom {
    export { type CustomCreateParams as CustomCreateParams, type CustomListParams as CustomListParams, type CustomDeleteParams as CustomDeleteParams, type CustomEditParams as CustomEditParams, type CustomGetParams as CustomGetParams, };
    export { Excludes as Excludes, type ExcludeUpdateParams as ExcludeUpdateParams, type ExcludeGetParams as ExcludeGetParams, };
    export { Includes as Includes, type IncludeUpdateParams as IncludeUpdateParams, type IncludeGetParams as IncludeGetParams, };
    export { FallbackDomains as FallbackDomains, type FallbackDomainUpdateParams as FallbackDomainUpdateParams, type FallbackDomainGetParams as FallbackDomainGetParams, };
}
export { SettingsPoliciesSinglePage };
//# sourceMappingURL=custom.d.ts.map