"use strict";
// File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsPoliciesSinglePage = exports.Custom = void 0;
const resource_1 = require("../../../../../resource.js");
const policies_1 = require("../policies.js");
Object.defineProperty(exports, "SettingsPoliciesSinglePage", { enumerable: true, get: function () { return policies_1.SettingsPoliciesSinglePage; } });
const ExcludesAPI = __importStar(require("./excludes.js"));
const excludes_1 = require("./excludes.js");
const FallbackDomainsAPI = __importStar(require("./fallback-domains.js"));
const fallback_domains_1 = require("./fallback-domains.js");
const IncludesAPI = __importStar(require("./includes.js"));
const includes_1 = require("./includes.js");
class Custom extends resource_1.APIResource {
    constructor() {
        super(...arguments);
        this.excludes = new ExcludesAPI.Excludes(this._client);
        this.includes = new IncludesAPI.Includes(this._client);
        this.fallbackDomains = new FallbackDomainsAPI.FallbackDomains(this._client);
    }
    /**
     * Creates a device settings profile to be applied to certain devices matching the
     * criteria.
     */
    create(params, options) {
        const { account_id, ...body } = params;
        return this._client.post(`/accounts/${account_id}/devices/policy`, { body, ...options })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a list of the device settings profiles for an account.
     */
    list(params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/policies`, policies_1.SettingsPoliciesSinglePage, options);
    }
    /**
     * Deletes a device settings profile and fetches a list of the remaining profiles
     * for an account.
     */
    delete(policyId, params, options) {
        const { account_id } = params;
        return this._client.getAPIList(`/accounts/${account_id}/devices/policy/${policyId}`, policies_1.SettingsPoliciesSinglePage, { method: 'delete', ...options });
    }
    /**
     * Updates a configured device settings profile.
     */
    edit(policyId, params, options) {
        const { account_id, ...body } = params;
        return this._client.patch(`/accounts/${account_id}/devices/policy/${policyId}`, {
            body,
            ...options,
        })._thenUnwrap((obj) => obj.result);
    }
    /**
     * Fetches a device settings profile by ID.
     */
    get(policyId, params, options) {
        const { account_id } = params;
        return this._client.get(`/accounts/${account_id}/devices/policy/${policyId}`, options)._thenUnwrap((obj) => obj.result);
    }
}
exports.Custom = Custom;
Custom.Excludes = excludes_1.Excludes;
Custom.Includes = includes_1.Includes;
Custom.FallbackDomains = fallback_domains_1.FallbackDomains;
//# sourceMappingURL=custom.js.map